import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        done = False
        reward = None

        try:
            # 1) Rotate gripper to 90° orientation
            ninety_deg_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])
            print("[Task] Rotating to 90° orientation")

            # Prepare drawer positions
            bottom_side_pos = positions['bottom_side_pos']
            bottom_anchor_pos = positions['bottom_anchor_pos']

    obs, reward, done = rotate(env, task, ninety_deg_quat)
obs, reward, done = move(env, task, bottom_side_pos)
    obs, reward, done = move(env, task, bottom_anchor_pos)
            if done:
                print("[Task] Task ended after move to anchor-pos-bottom")
                return

            # 4) Pull the drawer open
            print("[Task] Pulling bottom drawer")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
            if done:
                print("[Task] Task ended after pull")
                return

            # 5) Pick tomato1 from table
            tomato1_pos = positions['tomato1']
            print(f"[Task] Picking tomato1 at: {tomato1_pos}")
            obs, reward, done = pick(env, task, tomato1_pos)
            if done:
                print("[Task] Task ended after pick tomato1")
                return

            # 6) Place tomato1 on plate
            plate_pos = positions['plate']
            print(f"[Task] Placing tomato1 at plate: {plate_pos}")
            obs, reward, done = place(env, task, plate_pos)
            if done:
                print("[Task] Task ended after place tomato1")
                return

            # 7) Pick tomato2 from table
            tomato2_pos = positions['tomato2']
            print(f"[Task] Picking tomato2 at: {tomato2_pos}")
            obs, reward, done = pick(env, task, tomato2_pos)
            if done:
                print("[Task] Task ended after pick tomato2")
                return

            # 8) Place tomato2 on plate
            print(f"[Task] Placing tomato2 at plate: {plate_pos}")
            obs, reward, done = place(env, task, plate_pos)
            if done:
                print("[Task] Task ended after place tomato2")
                return

            # Final status
            if done:
                print("[Task] Completed successfully with reward:", reward)
            else:
                print("[Task] Plan executed but task not marked done. Reward:", reward)

        except Exception as e:
            print(f"[Task] Exception during plan execution: {e}")

    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()