    # === Retrieve Object Positions ===
    positions = get_object_positions()
    bottom_side_pos = positions['bottom_side_pos']
    bottom_anchor_pos = positions['bottom_anchor_pos']
    item1_pos = positions['item1']
    item2_pos = positions['item2']
    plate_pos = positions['plate']

    print("===== Executing Oracle Plan =====")
    # Step 1: Rotate gripper to 90 degrees about z-axis
    print("[Task] Step 1: rotate gripper to ninety_deg")
    target_quat = np.array([0.0, 0.0, np.sqrt(2)/2, np.sqrt(2)/2])
    obs, reward, done = rotate(env, task, target_quat)
    if done:
        print("[Task] Finished after rotate. Reward:", reward)
        return

    # Step 2: Move to drawer side position
    print("[Task] Step 2: move to drawer side position")
    obs, reward, done = move(env, task, bottom_side_pos)
    if done:
        print("[Task] Finished after move to side. Reward:", reward)
        return

    # Step 3: Move to drawer anchor position
    print("[Task] Step 3: move to drawer anchor position")
    obs, reward, done = move(env, task, bottom_anchor_pos)
    if done:
        print("[Task] Finished after move to anchor. Reward:", reward)
        return

    # Step 4: Pull the drawer open
    print("[Task] Step 4: pull drawer open")
    obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
    if done:
        print("[Task] Finished after pull. Reward:", reward)
        return

    # Step 5: Move to item1 position for picking
    print("[Task] Step 5: move above item1")
    obs, reward, done = move(env, task, item1_pos)
    if done:
        print("[Task] Finished after move to item1. Reward:", reward)
        return

    # Step 6: Pick up item1
    print("[Task] Step 6: pick item1")
    obs, reward, done = pick(env, task, item1_pos)
    if done:
        print("[Task] Finished after pick item1. Reward:", reward)
        return

    # Step 7: Move to plate position for placing item1
    print("[Task] Step 7: move above plate for placing item1")
    obs, reward, done = move(env, task, plate_pos)
    if done:
        print("[Task] Finished after move to plate. Reward:", reward)
        return

    # Step 8: Place item1 on plate
    print("[Task] Step 8: place item1 on plate")
    obs, reward, done = place(env, task, plate_pos)
    if done:
        print("[Task] Finished after place item1. Reward:", reward)
        return

    # Step 9: Move to item2 position for picking
    print("[Task] Step 9: move above item2")
    obs, reward, done = move(env, task, item2_pos)
    if done:
        print("[Task] Finished after move to item2. Reward:", reward)
        return

    # Step 10: Pick up item2
    print("[Task] Step 10: pick item2")
    obs, reward, done = pick(env, task, item2_pos)
    if done:
        print("[Task] Finished after pick item2. Reward:", reward)
        return

    # Step 11: Move to plate position for placing item2
    print("[Task] Step 11: move above plate for placing item2")
    obs, reward, done = move(env, task, plate_pos)
    if done:
        print("[Task] Finished after move to plate. Reward:", reward)
        return

    # Step 12: Place item2 on plate
    print("[Task] Step 12: place item2 on plate")
    obs, reward, done = place(env, task, plate_pos)
    if done:
        print("[Task] Finished after place item2. Reward:", reward)
        return

    print("[Task] Oracle plan executed. Final reward:", reward)
    print("===== End of Skeleton Task =====")
finally:
    # Always ensure the environment is properly shutdown
    shutdown_environment(env)