import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import move, rotate, pull, pick, place

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers (optional)
        init_video_writers(obs)

        # Wrap task.step and task.get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()

        # === Oracle Plan Execution ===
        # 1) Move to the bottom drawer side position
        print("[Plan] Step 1: Moving to bottom_side_pos")
        target_side = np.array(positions['bottom_side_pos'])
    [Frozen Code Start]
        obs, reward, done = move(env, task, target_pos=target_side)
    [Frozen Code End]
        if done:
            print("[Plan] ended early at step 1.")
            return

        # 2) Rotate gripper to ninety_deg around Z
        print("[Plan] Step 2: Rotating gripper by 90 degrees")
        angle = np.pi / 4  # 45° to get 90° rotation about Z
        target_quat = np.array([0.0, 0.0, np.sin(angle), np.cos(angle)])
        obs, reward, done = rotate(env, task, target_quat=target_quat)
        if done:
            print("[Plan] ended early at step 2.")
            return

        # 3) Move to the bottom drawer anchor position
        print("[Plan] Step 3: Moving to bottom_anchor_pos")
        target_anchor = np.array(positions['bottom_anchor_pos'])
        obs, reward, done = move(env, task, target_pos=target_anchor)
        if done:
            print("[Plan] ended early at step 3.")
            return

        # 4) Pull the drawer open
        print("[Plan] Step 4: Pulling drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Plan] ended early at step 4.")
            return

        # 5) Pick the first tomato (item1)
        print("[Plan] Step 5: Picking tomato1")
        first_tomato = np.array(positions['item1'])
        obs, reward, done = pick(env, task, target_pos=first_tomato)
        if done:
            print("[Plan] ended early at step 5.")
            return

        # 6) Place the first tomato onto the plate
        print("[Plan] Step 6: Placing tomato1 on plate")
        plate_pos = np.array(positions['plate'])
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Plan] ended early at step 6.")
            return

        # 7) Pick the second tomato (item2)
        print("[Plan] Step 7: Picking tomato2")
        second_tomato = np.array(positions['item2'])
        obs, reward, done = pick(env, task, target_pos=second_tomato)
        if done:
            print("[Plan] ended early at step 7.")
            return

        # 8) Place the second tomato onto the plate
        print("[Plan] Step 8: Placing tomato2 on plate")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Completed successfully. Final reward:", reward)
        else:
            print("[Task] Finished steps but done=False. Reward:", reward)

    finally:
        # Always ensure environment shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()