from pyrep.objects.shape import Shape
from env import setup_environment, shutdown_environment
from skill_code import move, rotate, pull, pick, place
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset environment and prepare video recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # Retrieve object positions and orientations
        positions = get_object_positions()
        side_pos_bottom = Shape('side-pos-bottom').get_position()
        zero_quat = Shape('zero_deg').get_quaternion()
        ninety_quat = Shape('ninety_deg').get_quaternion()
        item1_pos = positions.get('item1')
        item2_pos = positions.get('item2')
        plate_pos = positions.get('plate')

        # Execute the oracle plan
        print("[Task] Executing oracle plan")
        obs, reward, done = move(env, task, target_pos=side_pos_bottom)
        obs, reward, done = rotate(env, task, target_quat=ninety_quat)
        obs, reward, done = pull(env, task, pull_distance=0.1)
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)

        # Final outcome
        if done:
            print("[Task] Plan executed and task completed. Final reward:", reward)
        else:
            print("[Task] Plan executed but task not completed. Final reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
        raise

    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()