        if done:
            print("[Plan] Finished early after rotate. Reward:", reward)
            return

        # Step 2: Move gripper to side position of bottom drawer
        side_pos = positions['bottom_side_pos']
        print(f"[Plan] Step 2: move gripper to bottom side pos {side_pos}")
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("[Plan] Finished early after move to side. Reward:", reward)
            return

        # Step 3: Move gripper to anchor position of bottom drawer
        anchor_pos = positions['bottom_anchor_pos']
        print(f"[Plan] Step 3: move gripper to bottom anchor pos {anchor_pos}")
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("[Plan] Finished early after move to anchor. Reward:", reward)
            return

        # Step 4: Pull open the bottom drawer
        joint_pos = positions['bottom_joint_pos']
        direction_vec = anchor_pos - joint_pos
        pull_distance = np.linalg.norm(direction_vec)
        axis_idx = int(np.argmax(np.abs(direction_vec)))
        axis_map = {0: 'x', 1: 'y', 2: 'z'}
        pull_axis = axis_map[axis_idx]
        if direction_vec[axis_idx] < 0:
            pull_axis = '-' + pull_axis
        print(f"[Plan] Step 4: pull bottom drawer by {pull_distance:.3f} along {pull_axis}")
        obs, reward, done = pull(env, task, pull_distance, pull_axis)
        if done:
            print("[Plan] Finished early after pull. Reward:", reward)
            return

        # Step 5: Pick tomato1 from table
        tomato1_pos = positions['tomato1']
        print(f"[Plan] Step 5: pick tomato1 at {tomato1_pos}")
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Plan] Finished early after picking tomato1. Reward:", reward)
            return

        # Step 6: Place tomato1 on plate
        plate_pos = positions['plate']
        print(f"[Plan] Step 6: place tomato1 on plate at {plate_pos}")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Plan] Finished early after placing tomato1. Reward:", reward)
            return

        # Step 7: Pick tomato2 from table
        tomato2_pos = positions['tomato2']
        print(f"[Plan] Step 7: pick tomato2 at {tomato2_pos}")
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Plan] Finished early after picking tomato2. Reward:", reward)
            return

        # Step 8: Place tomato2 on plate
        print(f"[Plan] Step 8: place tomato2 on plate at {plate_pos}")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Plan] Finished early after placing tomato2. Reward:", reward)
            return

        # Final check
        print("[Plan] All steps executed. Final reward:", reward)
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")