[Frozen Code Start]
    
[Frozen Code End]

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Map PDDL object names to the keys used by get_object_positions()
        top_side_pos = positions['side-pos-top']
        top_anchor_pos = positions['anchor-pos-top']
        tomato1_pos    = positions['tomato1']
        tomato2_pos    = positions['tomato2']
        plate_pos      = positions['plate']

        # Define quaternions for zero and ninety degree rotations about the x-axis
        zero_quat   = np.array([0.0, 0.0, 0.0, 1.0])
        ninety_quat = np.array([np.sin(np.pi/4), 0.0, 0.0, np.cos(np.pi/4)])

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper to ninety degrees
        print("[Plan] Step 1: rotate gripper to ninety degrees")
        obs, reward, done = rotate(env, task, ninety_quat)
        if done:
            print("[Plan] Done flag received after rotate; ending early.")
            return

        # Step 2: Move gripper to the top anchor position
        print("[Plan] Step 2: move gripper to anchor-pos-top")
        obs, reward, done = move(env, task, top_anchor_pos)
        if done:
            print("[Plan] Done flag received after move to anchor-pos-top; ending early.")
            return

        # Step 3: Pull the drawer to open it
        print("[Plan] Step 3: pull drawer to open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Plan] Done flag received after pull; ending early.")
            return

        # Step 4: Move gripper to tomato1
        print("[Plan] Step 4: move gripper to tomato1")
        obs, reward, done = move(env, task, tomato1_pos)
        if done:
            print("[Plan] Done flag received after move to tomato1; ending early.")
            return

        # Step 5: Pick up tomato1
        print("[Plan] Step 5: pick tomato1")
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Plan] Done flag received after pick tomato1; ending early.")
            return

        # Step 6: Move gripper to plate
        print("[Plan] Step 6: move gripper to plate")
        obs, reward, done = move(env, task, plate_pos)
        if done:
            print("[Plan] Done flag received after move to plate; ending early.")
            return

        # Step 7: Place tomato1 on the plate
        print("[Plan] Step 7: place tomato1 on plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Plan] Done flag received after place tomato1; ending early.")
            return

        # Step 8: Move gripper to tomato2
        print("[Plan] Step 8: move gripper to tomato2")
        obs, reward, done = move(env, task, tomato2_pos)
        if done:
            print("[Plan] Done flag received after move to tomato2; ending early.")
            return

        # Step 9: Pick up tomato2
        print("[Plan] Step 9: pick tomato2")
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Plan] Done flag received after pick tomato2; ending early.")
            return

        # Step 10: Move gripper back to plate
        print("[Plan] Step 10: move gripper to plate")
        obs, reward, done = move(env, task, plate_pos)
        if done:
            print("[Plan] Done flag received after move to plate; ending early.")
            return

        # Step 11: Place tomato2 on the plate
        print("[Plan] Step 11: place tomato2 on plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Plan] Done flag received after place tomato2; ending early.")
            return

        print("[Plan] All steps executed. Final reward:", reward)