import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Skeleton task: open an unlocked drawer and toss two tomatoes onto a plate.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state and start video recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Expected keys: 'bottom_side_pos', 'bottom_anchor_pos', 'tomato1', 'tomato2', 'plate'
        bottom_side_pos = np.array(positions['bottom_side_pos'])
        bottom_anchor_pos = np.array(positions['bottom_anchor_pos'])
        tomato1_pos = np.array(positions['tomato1'])
        tomato2_pos = np.array(positions['tomato2'])
        plate_pos = np.array(positions['plate'])

        # === Task Plan Execution ===

        # 1) Move to side of bottom drawer
        # 2) Grasp drawer handle
        # 3) Pull drawer open
        # 4) Retreat to anchor
        # 5) Pick and place tomato1
        # 6) Pick and place tomato2

        # Frozen Code Region Start
        obs, reward, done = move(env, task, target_pos=bottom_side_pos)
        obs, reward, done = pick(env, task, target_pos=bottom_side_pos, approach_axis='z')
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        obs, reward, done = pick(env, task, target_pos=tomato1_pos, approach_axis='z')
        obs, reward, done = place(env, task, target_pos=plate_pos, approach_axis='z')
        obs, reward, done = pick(env, task, target_pos=tomato2_pos, approach_axis='z')
        # Frozen Code Region End

        # 7) Place tomato2 onto the plate
        obs, reward, done = place(env, task, target_pos=plate_pos, approach_axis='z')
        if done:
            print("[Task] Early termination after placing tomato2.")
        else:
            print("[Task] Completed: Drawer opened and tomatoes placed on plate. Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()