def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved positions
        bottom_pos = positions['bottom']
        middle_pos = positions['middle']
        top_pos = positions['top']
        plate_pos = positions['plate']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        gripper_pos = positions['gripper']

        # Step 1: Move to the bottom position
        print("[Task] Moving to bottom position:", bottom_pos)
        obs, reward, done = move(env, 'initial_room', bottom_pos)
        if done:
            print("[Task] Task ended after moving to bottom position!")
            return

        # Step 2: Pick the first tomato
        print("[Task] Picking tomato1 at:", tomato1_pos)
        obs, reward, done = pick(env, 'tomato1', bottom_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to the plate position
        print("[Task] Moving to plate position:", plate_pos)
        obs, reward, done = move(env, bottom_pos, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate position!")
            return

        # Step 4: Place the first tomato on the plate
        print("[Task] Placing tomato1 on plate.")
        obs, reward, done = place(env, 'tomato1', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 5: Move back to the bottom position
        print("[Task] Moving back to bottom position:", bottom_pos)
        obs, reward, done = move(env, plate_pos, bottom_pos)
        if done:
            print("[Task] Task ended after moving back to bottom position!")
            return

        # Step 6: Pick the second tomato
        print("[Task] Picking tomato2 at:", tomato2_pos)
        obs, reward, done = pick(env, 'tomato2', bottom_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 7: Move to the plate position again
        print("[Task] Moving to plate position:", plate_pos)
        obs, reward, done = move(env, bottom_pos, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate position!")
            return

        # Step 8: Place the second tomato on the plate
        print("[Task] Placing tomato2 on plate.")
        obs, reward, done = place(env, 'tomato2', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

        # Step 9: Move to the rubbish position
        print("[Task] Moving to rubbish position:", rubbish_pos)
        obs, reward, done = move(env, plate_pos, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish position!")
            return

        # Step 10: Place rubbish
        print("[Task] Placing rubbish.")
        obs, reward, done = place(env, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()