import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Map object names to their positions
        item1_pos = positions['tomato1']
        item2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # === Execute Oracle Plan ===
        # Step 1: Pick tomato1 from table
        print(f"[Task] Step 1: Picking tomato1 at: {item1_pos}")
        [Frozen Code Start]
        obs, reward, done = pick(
            env,
            task,
            target_pos=item1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        [Frozen Code End]
        if done:
            print("[Task] Ended prematurely after step 1. Reward:", reward)
            return

        # Step 2: Place tomato1 on the plate
        print(f"[Task] Step 2: Placing tomato1 at plate at: {plate_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Ended prematurely after step 2. Reward:", reward)
            return

        # Step 3: Pick tomato2 from table
        print(f"[Task] Step 3: Picking tomato2 at: {item2_pos}")
        obs, reward, done = pick(
            env,
            task,
            target_pos=item2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Ended prematurely after step 3. Reward:", reward)
            return

        # Step 4: Place tomato2 on the plate
        print(f"[Task] Step 4: Placing tomato2 at plate at: {plate_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Completed successfully after final step. Reward:", reward)
        else:
            print("[Task] All steps executed. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()