[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()
        # Initialize video writers (optional)
        init_video_writers(obs)

        # Wrap step/get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        tomato1_pos = positions.get('tomato1')
        tomato2_pos = positions.get('tomato2')
        plate_pos   = positions.get('plate')
        if tomato1_pos is None:
            raise ValueError("Position for 'tomato1' not found in object_positions.")
        if tomato2_pos is None:
            raise ValueError("Position for 'tomato2' not found in object_positions.")
        if plate_pos is None:
            raise ValueError("Position for 'plate' not found in object_positions.")

        # === Oracle Plan Execution ===
        # Step 1: pick tomato1 from table
        print("[Task] Step 1: pick 'tomato1' at:", tomato1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Terminated during pick tomato1. Reward:", reward)
            return

        # Step 2: place tomato1 on plate
        print("[Task] Step 2: place 'tomato1' at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Completed after placing tomato1! Reward:", reward)
            return

        # Step 3: pick tomato2 from table
        print("[Task] Step 3: pick 'tomato2' at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Terminated during pick tomato2. Reward:", reward)
            return

        # Step 4: place tomato2 on plate
        print("[Task] Step 4: place 'tomato2' at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Completed successfully after placing tomato2! Reward:", reward)
        else:
            print("[Task] Plan finished but done=False. Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
    finally:
        # Ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
