import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        try:
            tomato1_pos = positions['tomato1']
            tomato2_pos = positions['tomato2']
            plate_pos = positions['plate']
        except KeyError as e:
            print(f"[Error] Missing object position: {e}")
            return

        # === Execute Oracle Plan ===

        # Step 1-3: pick tomato1, place tomato1, pick tomato2
        [Frozen Code Start]
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        [Frozen Code End]

        # Step 4: place tomato2 on plate
        print("[Task] Step 4: Placing tomato2 at plate:", plate_pos)
        try:
            obs, reward, done = place(env, task, target_pos=plate_pos)
        except Exception as e:
            print("[Error] place(tomato2) failed:", e)
            return
        if done:
            print("[Task] Terminated early after placing tomato2. Reward:", reward)
            return

        # Final outcome
        if not done:
            print("[Task] Completed all steps. Final reward:", reward)
        else:
            print("[Task] Task reported done before final step. Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()