[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===

        # Step 1: Pick tomato1 from table
        tomato1_pos = positions.get('tomato1')
        if tomato1_pos is None:
            raise KeyError("tomato1 position not found in environment.")
        print(f"[Task] Step 1: Picking tomato1 at {tomato1_pos}")
        obs, reward, done = pick(
            env,
            task,
            target_pos=np.array(tomato1_pos),
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Terminated early after picking tomato1.")
            return

        # Step 2: Place tomato1 onto plate
        plate_pos = positions.get('plate')
        if plate_pos is None:
            raise KeyError("plate position not found in environment.")
        print(f"[Task] Step 2: Placing tomato1 on plate at {plate_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=np.array(plate_pos),
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Terminated early after placing tomato1.")
            return

        # Step 3: Pick tomato2 from table
        tomato2_pos = positions.get('tomato2')
        if tomato2_pos is None:
            raise KeyError("tomato2 position not found in environment.")
        print(f"[Task] Step 3: Picking tomato2 at {tomato2_pos}")
        obs, reward, done = pick(
            env,
            task,
            target_pos=np.array(tomato2_pos),
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Terminated early after picking tomato2.")
            return

        # Step 4: Place tomato2 onto plate
        print(f"[Task] Step 4: Placing tomato2 on plate at {plate_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=np.array(plate_pos),
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Terminated early after placing tomato2.")
            return

        print("[Task] All steps completed successfully. Final reward:", reward)

    except Exception as e:
        print(f"Error during task execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()