import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running the disposal task in simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Extract required positions for the plan
        try:
            tomato1_pos = positions['tomato1']
            tomato2_pos = positions['tomato2']
            plate_pos   = positions['plate']
        except KeyError as e:
            print(f"[Task] ERROR: Position for object {e} not found. Aborting task.")
            return

        # === Execute Oracle Plan ===
        # Step 1: Pick tomato1 from table
        print("[Task] Step 1: Picking tomato1 at:", tomato1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos
        )
        if done:
            print("[Task] Task ended prematurely after picking tomato1. Reward:", reward)
            return

        # Step 2: Place tomato1 on plate
        print("[Task] Step 2: Placing tomato1 at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos
        )
        if done:
            print("[Task] Task ended prematurely after placing tomato1. Reward:", reward)
            return

        # Step 3: Pick tomato2 from table
        print("[Task] Step 3: Picking tomato2 at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos
        )
        if done:
            print("[Task] Task ended prematurely after picking tomato2. Reward:", reward)
            return

        [Frozen Code Start]
        obs, reward, done = pick(
                env,
                task,
                target_pos=tomato1_pos
            )
        obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos
            )
        obs, reward, done = pick(
                env,
                task,
                target_pos=tomato2_pos
            )
        [Frozen Code End]

        # Step 4: Place tomato2 on plate
        print("[Task] Step 4: Placing tomato2 at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos
        )
        if done:
            print("[Task] Task ended prematurely after placing tomato2. Reward:", reward)
            return

        # Final status
        if done:
            print("[Task] Completed all steps. Final reward:", reward)
        else:
            print("[Task] Finished plan execution. done flag is", done, "reward:", reward)

    except Exception as e:
        print("[Task] Exception during execution:", e)
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()