from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor
import numpy as np
from env import setup_environment, shutdown_environment
from skill_code import pick, place, move
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset environment and initialize recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()
        tomato1_pos = np.array(positions['tomato1'])
        tomato2_pos = np.array(positions['tomato2'])
        plate_pos   = np.array(positions['plate'])

        # === Oracle Plan Execution ===

        # Step 1: Pick tomato1 from table
        print("[Step 1] Picking tomato1 at:", tomato1_pos)
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] pick tomato1 failed: {e}")
            return
        if done:
            print("[Info] Task ended prematurely after picking tomato1.")
            return

        # Step 2: Place tomato1 onto plate
        print("[Step 2] Placing tomato1 on plate at:", plate_pos)
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] place tomato1 failed: {e}")
            return
        if done:
            print("[Info] Task ended prematurely after placing tomato1.")
            return

        # Step 3: Pick tomato2 from table
        print("[Step 3] Picking tomato2 at:", tomato2_pos)
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] pick tomato2 failed: {e}")
            return
        if done:
            print("[Info] Task ended prematurely after picking tomato2.")
            return

        # Step 4: Place tomato2 onto plate
        print("[Step 4] Placing tomato2 on plate at:", plate_pos)
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] place tomato2 failed: {e}")
            return
        if done:
            print("[Info] Task ended prematurely after placing tomato2.")
        else:
            print("[Success] Completed all plan steps. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()