[Frozen Code Start]

[Frozen Code End]

from env import setup_environment, shutdown_environment
from skill_code import move, pick, rotate, pull
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions
import numpy as np

def run_skeleton_task():
    '''Execute the oracle plan to pull open any drawer that is not locked.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset task and get initial observation
        descriptions, obs = task.reset()
        
        # Initialize video recording if needed
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)
        
        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Map PDDL drawer side and anchor positions
        side_bottom_pos = positions['bottom_side_pos']
        anchor_bottom_pos = positions['bottom_anchor_pos']
        
        # Define quaternions for zero and ninety degrees (xyzw)
        quat_zero = np.array([0.0, 0.0, 0.0, 1.0])
        quat_ninety = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])
        
        # === Oracle Plan Execution ===
        # Step 1: rotate gripper from zero_deg to ninety_deg
        print("[Task] Step 1: rotate gripper to ninety degrees")
        obs, reward, done = rotate(env, task, quat_ninety)
        if done:
            print("[Task] Finished after rotation. Reward:", reward)
            return
        
        # Step 2: move gripper from current to side-bottom position
        print("[Task] Step 2: move gripper to side-bottom position:", side_bottom_pos)
        obs, reward, done = move(env, task, side_bottom_pos)
        if done:
            print("[Task] Finished after move-to-side. Reward:", reward)
            return
        
        # Step 3: move gripper from side-bottom to anchor-bottom position
        print("[Task] Step 3: move gripper to anchor-bottom position:", anchor_bottom_pos)
        obs, reward, done = move(env, task, anchor_bottom_pos)
        if done:
            print("[Task] Finished after move-to-anchor. Reward:", reward)
            return
        
        # Step 4: pick the bottom drawer at anchor position
        print("[Task] Step 4: pick drawer 'bottom' at anchor position")
        obs, reward, done = pick(env, task, anchor_bottom_pos)
        if done:
            print("[Task] Finished after pick. Reward:", reward)
            return
        
        # Step 5: pull open the bottom drawer (assume pull_distance=0.1 along 'x')
        print("[Task] Step 5: pull to open drawer 'bottom'")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Finished after pull. Reward:", reward)
        else:
            print("[Task] Plan completed. Final reward:", reward)
        
    finally:
        shutdown_environment(env)
    
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()