        if done:
            print("[Task] Terminated early after move to side. Reward:", reward)
            return

        # Step 3: Move to anchor position of bottom drawer
        print(f"[Task] Step 3: move to anchor position at {bottom_anchor_pos}")
        obs, reward, done = move(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Terminated early after move to anchor. Reward:", reward)
            return

        # Step 4: Pick (grasp) the drawer handle at anchor position
        print(f"[Task] Step 4: pick drawer handle at {bottom_anchor_pos}")
        obs, reward, done = pick(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Terminated early after pick. Reward:", reward)
            return

        # Step 5: Pull to slide open the drawer
        pull_distance = 0.1  # meters; adjust as needed
        pull_axis = 'x'      # assume drawer slides along the X-axis
        print(f"[Task] Step 5: pull drawer by {pull_distance}m along {pull_axis}-axis")
        obs, reward, done = pull(env, task, pull_distance, pull_axis=pull_axis)
        if done:
            print("[Task] Drawer opened successfully! Reward:", reward)
        else:
            print("[Task] Drawer may not be fully open; done flag is", done, "Reward:", reward)