[Frozen Code Start]

[Frozen Code End]

from env import setup_environment, shutdown_environment
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions
from skill_code import move, pick, place, rotate, pull
import numpy as np
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset task and initialize recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # Retrieve object positions
        positions = get_object_positions()
        bottom_side_pos = np.array(positions['bottom_side_pos'])
        bottom_anchor_pos = np.array(positions['bottom_anchor_pos'])

        # 1) Rotate gripper to 90° around Z axis
        quat_90 = R.from_euler('z', 90, degrees=True).as_quat()
        print("[Task] Rotating gripper to 90° around Z axis...")
        obs, reward, done = rotate(env, task, quat_90)
        if done:
            print("[Task] Task ended during rotate. Reward:", reward)
            return

        # 2) Move to side position of bottom drawer
        print(f"[Task] Moving to bottom side position: {bottom_side_pos}")
        obs, reward, done = move(env, task, bottom_side_pos)
        if done:
            print("[Task] Task ended during move-to-side. Reward:", reward)
            return

        # 3) Move to anchor position of bottom drawer
        print(f"[Task] Moving to bottom anchor position: {bottom_anchor_pos}")
        obs, reward, done = move(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Task ended during move-to-anchor. Reward:", reward)
            return

        # 4) Pick the drawer handle at the anchor position
        print(f"[Task] Picking drawer handle at anchor position: {bottom_anchor_pos}")
        obs, reward, done = pick(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Task ended during pick. Reward:", reward)
            return

        # 5) Pull the drawer to open it
        pull_distance = 0.2  # meters
        print(f"[Task] Pulling drawer by {pull_distance}m along +X axis...")
        obs, reward, done = pull(env, task, pull_distance, pull_axis='x')
        if done:
            print("[Task] Drawer opened successfully! Reward:", reward)
        else:
            print("[Task] Drawer may not be fully open. done flag:", done, "Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()