        # Step 5: Pull the drawer fully open
        # Compute pull axis and distance from anchor to joint position
        delta = bottom_joint - bottom_anchor
        axis_idx = int(np.argmax(np.abs(delta)))
        axis_names = {0: 'x', 1: 'y', 2: 'z'}
        sign = '' if delta[axis_idx] > 0 else '-'
        pull_axis = sign + axis_names[axis_idx]
        pull_distance = float(abs(delta[axis_idx]))
        print(f"[Task] Step 5: pull drawer along {pull_axis} by {pull_distance:.3f}m")
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis=pull_axis)
        if done:
            print("[Task] Drawer opened successfully! Reward:", reward)
        else:
            print("[Task] Pull done but done=False. Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()