import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Select an unlocked drawer to open (bottom or top; middle is locked)
        drawer = 'bottom'
        side_key = f"{drawer}_side_pos"
        anchor_key = f"{drawer}_anchor_pos"
        if side_key not in positions or anchor_key not in positions:
            raise KeyError(f"Expected keys {side_key} and {anchor_key} in positions.")
        side_pos = positions[side_key]
        anchor_pos = positions[anchor_key]

        print(f"[Task] Selected drawer: {drawer}")
        # Step 1: Rotate gripper to 90 degrees about the Y-axis for side approach
        from scipy.spatial.transform import Rotation as R
        print("[Task] Rotating gripper to side orientation")
        target_quat = R.from_euler('y', 90, degrees=True).as_quat()
        [Frozen Code Start]
        obs, reward, done = rotate(env, task, target_quat)
obs, reward, done = move(env, task, np.array(side_pos)
obs, reward, done = move(env, task, np.array(anchor_pos)
        [Frozen Code End]

        # check if any step ended the episode
        if done:
            print("[Task] Task ended prematurely.")
            return

        # Step 4: Pick (grasp) the drawer handle at the anchor position
        print(f"[Task] Picking drawer at anchor position: {anchor_pos}")
        obs, reward, done = pick(env, task, np.array(anchor_pos))
        if done:
            print("[Task] Task ended during pick.")
            return

        # Step 5: Pull the drawer fully open along the X-axis
        pull_distance = 0.2  # Adjust as needed to open fully
        pull_axis = 'x'
        print(f"[Task] Pulling drawer open by {pull_distance} along {pull_axis}-axis")
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis=pull_axis)
        if done:
            print("[Task] Task ended during pull.")
            return

        print("[Task] Drawer opened successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()