        # Step 3: Move to anchor position of bottom drawer
        print("[Plan] Step 3: move to bottom_anchor_pos", bottom_anchor_pos)
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Plan] Task ended during move-to-anchor. Reward:", reward)
            return

        # Step 4: Pick the bottom drawer handle
        print("[Plan] Step 4: pick bottom drawer at anchor_pos", bottom_anchor_pos)
        obs, reward, done = pick(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Plan] Task ended during pick. Reward:", reward)
            return

        # Step 5: Pull the drawer open
        pull_distance = float(np.linalg.norm(bottom_joint_pos - bottom_anchor_pos))
        print(f"[Plan] Step 5: pull drawer by distance {pull_distance:.3f}")
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        if done:
            print("[Plan] Task ended during pull. Reward:", reward)
            return

        # If we reach here, the drawer should be open
        print("[Task] Drawer opened successfully! Final reward:", reward)