import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        bottom_side_pos = positions.get('bottom_side_pos', positions.get('side-pos-bottom'))
        bottom_anchor_pos = positions.get('bottom_anchor_pos', positions.get('anchor-pos-bottom'))
        if bottom_side_pos is None or bottom_anchor_pos is None:
            raise KeyError("Required object positions not found in positions dict.")
        bottom_side_pos = np.array(bottom_side_pos)
        bottom_anchor_pos = np.array(bottom_anchor_pos)

        # === Oracle Plan Execution ===

        # Step 1: rotate gripper to ninety_deg
        print("[Step 1] Rotating gripper to 90 degrees around z-axis")
        target_quat = R.from_euler('z', 90, degrees=True).as_quat()
[Frozen Code Start]
    obs, reward, done = rotate(env, task, target_quat)
obs, reward, done = move(env, task, bottom_side_pos)
    obs, reward, done = move(env, task, bottom_anchor_pos)
[Frozen Code End]
        if done:
            print("Task ended during initial steps. Reward:", reward)
            return

        # Step 4: pick the drawer at its anchor position
        print("[Step 4] Picking the bottom drawer")
        obs, reward, done = pick(env, task, bottom_anchor_pos)
        if done:
            print("Task ended during pick. Reward:", reward)
            return

        # Step 5: pull the drawer to open it
        print("[Step 5] Pulling the bottom drawer to open")
        pull_distance = 0.1  # meters
        obs, reward, done = pull(env, task, pull_distance, pull_axis='x')
        if done:
            print("Task ended during pull. Reward:", reward)
            return

        print("Task completed successfully. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()