[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_joint_pos = positions['bottom_joint_pos']

        # === Oracle Plan Execution ===

        # Step 1: rotate gripper from 0° to 90° about the z-axis
        print("[Task] Step 1: Rotate gripper to 90° about z-axis")
        # compute quaternion for 90° about z axis in xyzw format
        from scipy.spatial.transform import Rotation as R
        target_quat = R.from_euler('z', 90, degrees=True).as_quat()
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Ended during rotate.")
            return

        # Step 2: move to the side position of the bottom drawer
        print("[Task] Step 2: Move to side position of bottom drawer")
        obs, reward, done = move(env, task, target_pos=bottom_side_pos)
        if done:
            print("[Task] Ended during move-to-side.")
            return

        # Step 3: move to the anchor (handle) position of the bottom drawer
        print("[Task] Step 3: Move to anchor (handle) position of bottom drawer")
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Task] Ended during move-to-anchor.")
            return

        # Step 4: pick (grasp) the bottom drawer handle
        print("[Task] Step 4: Pick the bottom drawer handle")
        obs, reward, done = pick(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Task] Ended during pick.")
            return

        # Step 5: pull the drawer along its primary axis to open
        print("[Task] Step 5: Pull the bottom drawer to open")
        diff = bottom_joint_pos - bottom_anchor_pos
        pull_distance = np.linalg.norm(diff)
        idx = int(np.argmax(np.abs(diff)))
        if idx == 0:
            pull_axis = 'x' if diff[0] > 0 else '-x'
        elif idx == 1:
            pull_axis = 'y' if diff[1] > 0 else '-y'
        else:
            pull_axis = 'z' if diff[2] > 0 else '-z'
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis=pull_axis)
        if done:
            print("[Task] Ended during pull.")
            return

        print("[Task] Completed successfully. The bottom drawer should now be open and cabinet unlocked.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()