import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers if needed
        init_video_writers(obs)

        # Wrap the task.step and task.get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Plan Execution ===
        # Step 1: pick item1 from its current location
        try:
            item1_pos = positions['item1']
        except KeyError as e:
            print(f"[Task] ERROR: Missing position for {e}")
            return
        print(f"[Task] Step 1: Picking up 'item1' at position {item1_pos}")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print(f"[Task] Task ended during pick. Reward: {reward}")
            return

        # Step 2: place item1 into bin
        try:
            bin_pos = positions['bin']
        except KeyError as e:
            print(f"[Task] ERROR: Missing position for {e}")
            return
        print(f"[Task] Step 2: Placing 'item1' into 'bin' at position {bin_pos}")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print(f"[Task] Task completed successfully! Reward: {reward}")
        else:
            print(f"[Task] Task not completed. Reward: {reward}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()