import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Verify required objects are present
        if 'rubbish' not in positions:
            print("[Task] Error: 'rubbish' not found in object positions.")
            return
        if 'bin' not in positions:
            print("[Task] Error: 'bin' not found in object positions.")
            return

        # Map 'rubbish' to the frozen variable item2_pos so pick can use it
        item2_pos = positions['rubbish']
        bin_pos = positions['bin']
        print(f"[Task] rubbish position (item2_pos): {item2_pos}")
        print(f"[Task] bin position: {bin_pos}")

        # === Plan Execution ===

        # Step 1: pick rubbish from the table
        print("[Task] Step 1: Picking 'rubbish'.")
        obs, reward, done = pick(env, task, item2_pos)
        if done:
            print(f"[Task] Task ended after pick. Reward: {reward}")
            return

        # Step 2: place rubbish into the bin
        print("[Task] Step 2: Placing 'rubbish' into 'bin'.")
        try:
            obs, reward, done = place(env, task, bin_pos)
        except Exception as e:
            print(f"[Task] Exception during place: {e}")
            return
        if done:
            print(f"[Task] Task completed successfully! Reward: {reward}")
        else:
            print(f"[Task] Task not completed yet (done=False). Current reward: {reward}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()