import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers if needed
        init_video_writers(obs)

        # Wrap task methods for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # We need the 'rubbish' object and the 'bin' location
        item2_pos = positions.get('rubbish')
        bin_pos = positions.get('bin')
        if item2_pos is None or bin_pos is None:
            raise ValueError("Required object positions not found for 'rubbish' or 'bin'")

        # === Oracle Plan Execution ===
        try:
            # Step 1: pick rubbish from table
            print("[Task] Picking rubbish at:", item2_pos)
            obs, reward, done = pick(
                env=env,
                task=task,
                target_pos=item2_pos
            )
            if done:
                print("[Task] Task ended after pick. Reward:", reward)
                return

            # Step 2: place rubbish into bin
            print("[Task] Placing rubbish to bin at:", bin_pos)
            obs, reward, done = place(
                env=env,
                task=task,
                target_pos=bin_pos
            )
            if done:
                print("[Task] Task completed successfully! Reward:", reward)
                return
            else:
                print("[Task] Task not completed yet (done=False). Reward:", reward)
        except Exception as e:
            print(f"[Task] Exception during execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()