def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects 'item1' and 'item2' in the environment
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        bin_pos = positions['bin']

        # Step 1: Approach and pick item1
        print("[Task] Manipulating item1 at:", item1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=item1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating item1!")
            return

        # Step 2: Place item1 in the bin
        print("[Task] Placing item1 in the bin at:", bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos
        )
        if done:
            print("[Task] Task ended after placing item1!")
            return

        # Step 3: Approach and pick item2
        print("[Task] Manipulating item2 at:", item2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=item2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating item2!")
            return

        # Step 4: Place item2 in the bin
        print("[Task] Placing item2 in the bin at:", bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos
        )
        if done:
            print("[Task] Task ended after placing item2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()