def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'object_1' to manipulate
        object_1_pos = positions['object_1']
        robot_initial_pos = positions['robot']

        # Step 1: Move to the object's location
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, robot_initial_pos, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Close the gripper to prepare for picking
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 3: Pick the object
        print("[Task] Picking object_1.")
        obs, reward, done = pick(env, 'object_1', object_1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 4: Move to a new location to place the object
        new_location = positions['new_location']
        print("[Task] Moving to new location:", new_location)
        obs, reward, done = move(env, object_1_pos, new_location)
        if done:
            print("[Task] Task ended after moving to new location!")
            return

        # Step 5: Place the object
        print("[Task] Placing object_1.")
        obs, reward, done = place(env, 'object_1', new_location)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()