def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define object positions based on the retrieved data
        item1_pos = positions['item1']  # e.g., position of tomato 1
        item2_pos = positions['item2']  # e.g., position of tomato 2
        plate_pos = positions['plate']   # e.g., position of the plate

        # Safety check: Ensure the plate is not occupied before moving towards it
        if not obs['plate_occupied']:  # Assuming obs provides this information
            # Step 1: Pick item1
            print("[Task] Picking item1 at:", item1_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=item1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after picking item1!")
                return

            # Step 2: Place item1 on the plate
            print("[Task] Placing item1 on the plate at:", plate_pos)
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after placing item1!")
                return

            # Step 3: Pick item2
            print("[Task] Picking item2 at:", item2_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=item2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after picking item2!")
                return

            # Step 4: Place item2 on the plate
            print("[Task] Placing item2 on the plate at:", plate_pos)
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after placing item2!")
                return

        else:
            print("[Task] The plate is occupied, cannot proceed with placing items.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()