def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'object_1' to manipulate
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']

        # Check if object_1 is present before attempting to pick it
        if 'object_1' in positions:
            print("[Task] Manipulating object_1 at:", object_1_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_1_pos,
                max_steps=100,
                threshold=0.01,
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating object_1!")
                return

        # Check if object_2 is present before attempting to pick it
        if 'object_2' in positions:
            print("[Task] Manipulating object_2 at:", object_2_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_2_pos,
                max_steps=100,
                threshold=0.01,
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating object_2!")
                return

        # Example of placing the object back after manipulation
        if 'object_1' in positions:
            print("[Task] Placing object_1 back.")
            obs, reward, done = place(
                env,
                task,
                target_pos=object_1_pos,
                max_steps=100,
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after placing object_1!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()