def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the target objects
        target_objects = ['tomato1', 'tomato2']
        
        # Check if target objects are present
        for target in target_objects:
            if target not in positions:
                print(f"Target object '{target}' not found in object list.")
                return

        # Example positions for the target objects
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        
        # Move to the location of tomato1
        print("[Task] Moving to tomato1's position:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Pick up tomato1
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', obs.robot_position)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Move to the location of tomato2
        print("[Task] Moving to tomato2's position:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Place tomato1 at the location of tomato2
        print("[Task] Placing tomato1 at tomato2's position.")
        obs, reward, done = place(env, 'tomato1', tomato2_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()