def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object to manipulate
        target_object = 'object_1'  # Replace with actual object name
        if target_object not in positions:
            raise ValueError(f"Target object '{target_object}' is not in the object list.")

        target_pos = positions[target_object]

        # Example Task Plan
        print(f"[Task] Manipulating {target_object} at:", target_pos)

        # Move to the object's position
        obs, reward, done = move(env, task, 'current_room', 'target_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to the target room!")
            return

        # Pick the object
        obs, reward, done = pick(env, target_object, 'target_room', 'gripper')  # Replace with actual room and gripper
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to another location to place the object
        obs, reward, done = move(env, task, 'target_room', 'destination_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to the destination room!")
            return

        # Place the object
        obs, reward, done = place(env, target_object, 'destination_room')  # Replace with actual room
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()