def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the target object and its position
        target_object = 'object_1'  # Replace with actual object name
        if target_object not in positions:
            print("Target object not found in object list.")
            return

        target_pos = positions[target_object]

        # Check if the robot is at the correct location to pick the object
        robot_location = 'room_a'  # Replace with actual robot location
        if not obs.robot_at(robot_location):
            print(f"Moving robot to {robot_location} to pick {target_object}.")
            move(env, robot_location, 'room_a')  # Move to the room where the object is

        # Attempt to pick the object
        print(f"Attempting to pick {target_object} at {target_pos}.")
        obs, reward, done = pick(env, target_object, robot_location)
        if done:
            print(f"Successfully picked {target_object}.")
        else:
            print(f"Failed to pick {target_object}.")
            return

        # Now place the object in a new location
        new_location = 'room_b'  # Replace with actual new location
        print(f"Placing {target_object} in {new_location}.")
        obs, reward, done = place(env, target_object, new_location)
        if done:
            print(f"Successfully placed {target_object} in {new_location}.")
        else:
            print(f"Failed to place {target_object} in {new_location}.")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()