def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        plate_pos = positions['plate']
        tomato1_pos = positions['item1']
        tomato2_pos = positions['item2']
        tomato3_pos = positions['item3']
        switch_pos = positions['switch']
        bin_pos = positions['bin']

        # Step 1: Move to the first tomato
        print("[Task] Moving to tomato 1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato 1!")
            return

        # Step 2: Pick up the first tomato
        print("[Task] Picking up tomato 1")
        obs, reward, done = pick(env, task, 'item1', 'room', 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato 1!")
            return

        # Step 3: Move to the plate
        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        # Step 4: Place the first tomato on the plate
        print("[Task] Placing tomato 1 on the plate")
        obs, reward, done = place(env, task, 'item1', 'plate')
        if done:
            print("[Task] Task ended after placing tomato 1!")
            return

        # Step 5: Repeat for the second tomato
        print("[Task] Moving to tomato 2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato 2!")
            return

        print("[Task] Picking up tomato 2")
        obs, reward, done = pick(env, task, 'item2', 'room', 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato 2!")
            return

        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        print("[Task] Placing tomato 2 on the plate")
        obs, reward, done = place(env, task, 'item2', 'plate')
        if done:
            print("[Task] Task ended after placing tomato 2!")
            return

        # Step 6: Repeat for the third tomato
        print("[Task] Moving to tomato 3 at:", tomato3_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], tomato3_pos)
        if done:
            print("[Task] Task ended after moving to tomato 3!")
            return

        print("[Task] Picking up tomato 3")
        obs, reward, done = pick(env, task, 'item3', 'room', 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato 3!")
            return

        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        print("[Task] Placing tomato 3 on the plate")
        obs, reward, done = place(env, task, 'item3', 'plate')
        if done:
            print("[Task] Task ended after placing tomato 3!")
            return

        # Step 7: Move to the switch to turn on the light
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 8: Close the gripper to press the switch
        print("[Task] Closing gripper to press the switch")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 9: Move to the bin to dispose of any rubbish
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Final step: Dispose of rubbish if holding
        if obs.gripper_openness < 0.0:  # Assuming gripper is closed
            print("[Task] Dropping rubbish in the bin")
            obs, reward, done = drop(env, task, 'rubbish', 'bin')
            if done:
                print("[Task] Task ended after disposing of rubbish!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()