def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named as follows based on the provided feedback
        switch_pos = positions['switch']
        bin_pos = positions['bin']
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']

        # Step 1: Move to the switch to press it
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, task, obs.robot_position, switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 2: Close the gripper to prepare for pressing
        print("[Task] Closing gripper to press the switch.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing the gripper!")
            return

        # Step 3: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 4: Move to pick up item1
        print("[Task] Moving to pick up item1 at:", item1_pos)
        obs, reward, done = move(env, task, obs.robot_position, item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 5: Pick item1
        print("[Task] Picking up item1.")
        obs, reward, done = pick(env, task, 'item1', item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 6: Move to the bin to drop item1
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 7: Drop item1 in the bin
        print("[Task] Dropping item1 in the bin.")
        obs, reward, done = place(env, task, 'item1', bin_pos)
        if done:
            print("[Task] Task ended after dropping item1!")
            return

        # Step 8: Repeat for item2 and item3
        for item in ['item2', 'item3']:
            print(f"[Task] Moving to pick up {item} at:", positions[item])
            obs, reward, done = move(env, task, obs.robot_position, positions[item])
            if done:
                print(f"[Task] Task ended after moving to {item}!")
                return

            print(f"[Task] Picking up {item}.")
            obs, reward, done = pick(env, task, item, positions[item])
            if done:
                print(f"[Task] Task ended after picking {item}!")
                return

            print(f"[Task] Moving to the bin at:", bin_pos)
            obs, reward, done = move(env, task, obs.robot_position, bin_pos)
            if done:
                print(f"[Task] Task ended after moving to the bin for {item}!")
                return

            print(f"[Task] Dropping {item} in the bin.")
            obs, reward, done = place(env, task, item, bin_pos)
            if done:
                print(f"[Task] Task ended after dropping {item}!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()