def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (replace with actual keys)
        object_1_pos = positions['object_1']  # Replace with actual object key
        object_2_pos = positions['object_2']  # Replace with actual object key
        plate_pos = positions['plate']  # Replace with actual plate key

        # Check if object_1 is in the environment
        if 'object_1' not in positions:
            print("Error: object_1 is not in the environment.")
            return

        # Check if object_1 is already in the plate
        if obs.holding == 'object_1':
            print("object_1 is already in the plate.")
            return

        # Step 1: Move to object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, task, obs.robot_position, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick object_1
        print("[Task] Picking object_1...")
        obs, reward, done = pick(env, task, object_1_pos)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to plate
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 4: Place object_1 on plate
        print("[Task] Placing object_1 on plate...")
        obs, reward, done = place(env, task, 'object_1', plate_pos)
        if done:
            print("[Task] Task ended after placing object_1 on plate!")
            return

        print("[Task] Completed all actions successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()