def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are 'item1', 'item2', 'item3', 'switch', and 'bin'
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        switch_pos = positions['switch']
        bin_pos = positions['bin']

        # Step 1: Move to item1
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, task, 'current_location', item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, task, item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to switch
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, task, item1_pos, switch_pos)
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 4: Press switch
        print("[Task] Pressing switch...")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing switch!")
            return

        # Step 5: Move to bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, switch_pos, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 6: Place item1 in bin
        print("[Task] Placing item1 in bin...")
        obs, reward, done = place(env, task, item1_pos, bin_pos)
        if done:
            print("[Task] Task ended after placing item1 in bin!")
            return

        # Step 7: Move to item2
        print("[Task] Moving to item2 at:", item2_pos)
        obs, reward, done = move(env, task, bin_pos, item2_pos)
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        # Step 8: Pick item2
        print("[Task] Picking item2...")
        obs, reward, done = pick(env, task, item2_pos)
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 9: Move to bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, item2_pos, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 10: Place item2 in bin
        print("[Task] Placing item2 in bin...")
        obs, reward, done = place(env, task, item2_pos, bin_pos)
        if done:
            print("[Task] Task ended after placing item2 in bin!")
            return

        # Step 11: Move to item3
        print("[Task] Moving to item3 at:", item3_pos)
        obs, reward, done = move(env, task, bin_pos, item3_pos)
        if done:
            print("[Task] Task ended after moving to item3!")
            return

        # Step 12: Pick item3
        print("[Task] Picking item3...")
        obs, reward, done = pick(env, task, item3_pos)
        if done:
            print("[Task] Task ended after picking item3!")
            return

        # Step 13: Move to bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, item3_pos, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 14: Place item3 in bin
        print("[Task] Placing item3 in bin...")
        obs, reward, done = place(env, task, item3_pos, bin_pos)
        if done:
            print("[Task] Task ended after placing item3 in bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()