def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object to pick and a location to place it
        object_to_pick = 'object_1'  # Replace with actual object name
        object_to_place = 'object_2'  # Replace with actual object name
        object_1_pos = positions[object_to_pick]
        object_2_pos = positions[object_to_place]

        # Step 1: Move to the object to pick
        print(f"[Task] Moving to pick {object_to_pick} at:", object_1_pos)
        obs, reward, done = move(env, task, current_location, object_1_pos)
        if done:
            print("[Task] Task ended after moving to pick location!")
            return

        # Step 2: Pick the object
        print(f"[Task] Picking {object_to_pick}")
        obs, reward, done = pick(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the place location
        print(f"[Task] Moving to place {object_to_pick} at:", object_2_pos)
        obs, reward, done = move(env, task, object_1_pos, object_2_pos)
        if done:
            print("[Task] Task ended after moving to place location!")
            return

        # Step 4: Place the object
        print(f"[Task] Placing {object_to_pick} at {object_2_pos}")
        obs, reward, done = place(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()