def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object to manipulate
        target_object = 'object_1'  # Replace with actual object name
        target_pos = positions[target_object]

        # Check if the target object is in the object list
        if target_object not in positions:
            print("Error: Target object not found in object list.")
            return

        # Move to the target position
        print(f"[Task] Moving to {target_object} at:", target_pos)
        obs, reward, done = move(env, task, from_room='current_room', to_room=target_pos)
        if done:
            print("[Task] Task ended after moving to target position!")
            return

        # Attempt to pick the object
        print(f"[Task] Picking up {target_object}.")
        obs, reward, done = pick(env, target_object, target_pos, gripper='gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Check if the gripper is calibrated
        initial_gripper_state = getattr(obs, 'gripper_openness', -1.0)
        if initial_gripper_state < 0.5:  # Adjust the threshold as needed
            print("Error: Gripper not calibrated.")
            return

        # Move to a safe position to place the object
        safe_position = 'safe_room'  # Replace with actual safe room name
        print(f"[Task] Moving to safe position: {safe_position}.")
        obs, reward, done = move(env, task, from_room=target_pos, to_room=safe_position)
        if done:
            print("[Task] Task ended after moving to safe position!")
            return

        # Attempt to place the object
        print(f"[Task] Placing {target_object} at safe position.")
        obs, reward, done = place(env, target_object, safe_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()