def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object to pick
        ball_pos = positions['ball']  # Replace 'ball' with the actual object name if different
        room_pos = positions['room']  # Replace 'room' with the actual room name if different

        # Check if the ball is in the environment
        if 'ball' not in env.object_list:
            print("Error: Target object 'ball' not found in object list.")
            return

        # Step 1: Move to the room where the ball is located
        print(f"[Task] Moving to room at: {room_pos}")
        obs, reward, done = move(env, task, current_room, room_pos)
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Step 2: Pick the ball
        print(f"[Task] Picking up the ball at: {ball_pos}")
        obs, reward, done = pick(env, task, target_pos=ball_pos)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 3: Move to the disposal area (assuming we have a disposal location)
        disposal_pos = positions['disposal']  # Replace 'disposal' with the actual disposal location name
        print(f"[Task] Moving to disposal area at: {disposal_pos}")
        obs, reward, done = move(env, task, current_room, disposal_pos)
        if done:
            print("[Task] Task ended after moving to the disposal area!")
            return

        # Step 4: Place the ball in the disposal area
        print(f"[Task] Placing the ball at: {disposal_pos}")
        obs, reward, done = place(env, task, target_pos=disposal_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()