def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        item1_pos = positions['item1']  # Example object
        item2_pos = positions['item2']  # The object we need to pick

        # Step 1: Move to item1's position
        print("[Task] Moving to item1 position:", item1_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Example rooms
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1 at:", item1_pos)
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to item2's position
        print("[Task] Moving to item2 position:", item2_pos)
        obs, reward, done = move(env, 'room_b', 'room_c')  # Example rooms
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        # Step 4: Pick item2
        print("[Task] Picking item2 at:", item2_pos)
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 5: Place item1 in a designated location
        print("[Task] Placing item1 in the designated location.")
        obs, reward, done = place(env, task, target_pos='designated_location')  # Example location
        if done:
            print("[Task] Task ended after placing item1!")
            return

        # Step 6: Place item2 in a designated location
        print("[Task] Placing item2 in the designated location.")
        obs, reward, done = place(env, task, target_pos='designated_location')  # Example location
        if done:
            print("[Task] Task ended after placing item2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()