def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects: item1 and item2
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        robot_pos = positions['robot']

        # Step 1: Move to item1
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, task, robot_pos, item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1")
        obs, reward, done = pick(env, task, 'item1', item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to item2
        print("[Task] Moving to item2 at:", item2_pos)
        obs, reward, done = move(env, task, item1_pos, item2_pos)
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        # Step 4: Place item1 at item2's location
        print("[Task] Placing item1 at item2's location")
        obs, reward, done = place(env, task, 'item1', item2_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

        # Step 5: Press the switch (assuming it's at item2's location)
        print("[Task] Pressing the switch at item2's location")
        obs, reward, done = press(env, task, item2_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()