def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        plate_pos = positions['plate']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        # Step 1: Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, 'current_room', 'room_with_tomato1')
        if done:
            print("[Task] Reached tomato1.")
        else:
            print("[Task] Failed to reach tomato1.")
            return

        # Step 2: Pick up tomato1
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'room_with_tomato1')
        if done:
            print("[Task] Picked up tomato1.")
        else:
            print("[Task] Failed to pick up tomato1.")
            return

        # Step 3: Move to plate
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, 'room_with_tomato1', 'room_with_plate')
        if done:
            print("[Task] Reached plate.")
        else:
            print("[Task] Failed to reach plate.")
            return

        # Step 4: Place tomato1 on plate
        print("[Task] Placing tomato1 on plate.")
        obs, reward, done = place(env, 'tomato1', 'room_with_plate')
        if done:
            print("[Task] Placed tomato1 on plate.")
        else:
            print("[Task] Failed to place tomato1 on plate.")
            return

        # Step 5: Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, 'room_with_plate', 'room_with_tomato2')
        if done:
            print("[Task] Reached tomato2.")
        else:
            print("[Task] Failed to reach tomato2.")
            return

        # Step 6: Pick up tomato2
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', 'room_with_tomato2')
        if done:
            print("[Task] Picked up tomato2.")
        else:
            print("[Task] Failed to pick up tomato2.")
            return

        # Step 7: Move to plate again
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, 'room_with_tomato2', 'room_with_plate')
        if done:
            print("[Task] Reached plate.")
        else:
            print("[Task] Failed to reach plate.")
            return

        # Step 8: Place tomato2 on plate
        print("[Task] Placing tomato2 on plate.")
        obs, reward, done = place(env, 'tomato2', 'room_with_plate')
        if done:
            print("[Task] Placed tomato2 on plate.")
        else:
            print("[Task] Failed to place tomato2 on plate.")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()