def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'tomato' and 'plate'
        tomato_pos = positions['tomato']
        plate_pos = positions['plate']

        # Step 1: Move to the tomato's position
        print("[Task] Moving to tomato at:", tomato_pos)
        obs, reward, done = move(env, task, from_room='room_with_tomato', to_room='room_with_tomato')
        if done:
            print("[Task] Task ended after moving to tomato!")
            return

        # Step 2: Pick up the tomato
        print("[Task] Picking up the tomato.")
        obs, reward, done = pick(env, 'tomato', 'room_with_tomato', 'gripper')
        if done:
            print("[Task] Task ended after picking up the tomato!")
            return

        # Step 3: Move to the plate's position
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, task, from_room='room_with_tomato', to_room='room_with_plate')
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 4: Place the tomato on the plate
        print("[Task] Placing the tomato on the plate.")
        obs, reward, done = place(env, 'tomato', 'room_with_plate')
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()