def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'object_1' to manipulate
        object_name = 'object_1'
        target_location = (1.0, 0.0, 0.0)  # Example target location

        # Step 1: Move to the object's location
        object_pos = positions[object_name]
        print(f"[Task] Moving to {object_name} at:", object_pos)
        obs, reward, done = move(env, task, from_room='room_a', to_room='room_b')  # Adjust rooms as necessary
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick the object
        print(f"[Task] Picking up {object_name}...")
        obs, reward, done = pick(env, object_name, 'room_b', 'gripper')  # Adjust room and gripper as necessary
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the target location
        print(f"[Task] Moving to target location: {target_location}...")
        obs, reward, done = move(env, task, from_room='room_b', to_room='room_c')  # Adjust rooms as necessary
        if done:
            print("[Task] Task ended after moving to the target location!")
            return

        # Step 4: Place the object at the target location
        print(f"[Task] Placing {object_name} at target location...")
        obs, reward, done = place(env, object_name, 'room_c')  # Adjust room as necessary
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()