def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named as follows based on the provided PDDL
        rubbish_pos = positions['rubbish']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        # Step 1: Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the first tomato location
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 4: Place the rubbish at the first tomato location
        print("[Task] Placing rubbish at tomato1.")
        obs, reward, done = place(env, 'rubbish', tomato1_pos)
        if done:
            print("[Task] Task ended after placing rubbish at tomato1!")
            return

        # Step 5: Move to the second tomato location
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Place the rubbish at the second tomato location
        print("[Task] Placing rubbish at tomato2.")
        obs, reward, done = place(env, 'rubbish', tomato2_pos)
        if done:
            print("[Task] Task ended after placing rubbish at tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()