def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to manipulate
        object_1_pos = positions['item1']  # Replace 'item1' with actual object name
        object_2_pos = positions['item2']  # Replace 'item2' with actual object name

        # Safety check: Ensure the environment is clear before starting
        if not obs.is_safe():
            print("[Error] Environment is not safe to proceed.")
            return

        # Step 1: Move to object 1's position
        print("[Task] Moving to object 1 at:", object_1_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to object 1!")
            return

        # Step 2: Pick object 1
        print("[Task] Picking object 1...")
        obs, reward, done = pick(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after picking object 1!")
            return

        # Step 3: Move to object 2's position
        print("[Task] Moving to object 2 at:", object_2_pos)
        obs, reward, done = move(env, 'room_b', 'room_c')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to object 2!")
            return

        # Step 4: Pick object 2
        print("[Task] Picking object 2...")
        obs, reward, done = pick(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended after picking object 2!")
            return

        # Step 5: Place object 1 in a designated location
        print("[Task] Placing object 1...")
        obs, reward, done = place(env, task, target_pos='designated_location_1')  # Replace with actual location
        if done:
            print("[Task] Task ended after placing object 1!")
            return

        # Step 6: Place object 2 in a designated location
        print("[Task] Placing object 2...")
        obs, reward, done = place(env, task, target_pos='designated_location_2')  # Replace with actual location
        if done:
            print("[Task] Task ended after placing object 2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()