def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'tomato1' and 'tomato2' and are in the 'bin'
        tomato1_pos = positions['tomato1']  # Position of tomato1
        tomato2_pos = positions['tomato2']  # Position of tomato2
        bin_pos = positions['bin']           # Position of the bin
        plate_pos = positions['plate']       # Position of the plate

        # Check if the robot is at the bin location
        obs = task.get_observation()
        if not obs.robot_at(bin_pos):
            print("[Task] Moving to the bin to pick up the tomatoes.")
            obs, reward, done = move(env, task, obs.robot_position, bin_pos)
            if done:
                print("[Task] Task ended after moving to the bin!")
                return

        # Pick up tomato1 from the bin
        print("[Task] Picking up tomato1 from the bin.")
        obs, reward, done = pick(env, task, 'tomato1', bin_pos)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Move to the plate to place tomato1
        print("[Task] Moving to the plate to place tomato1.")
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        # Place tomato1 on the plate
        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, task, 'tomato1', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Repeat the process for tomato2
        print("[Task] Moving to the bin to pick up tomato2.")
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        print("[Task] Picking up tomato2 from the bin.")
        obs, reward, done = pick(env, task, 'tomato2', bin_pos)
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        print("[Task] Moving to the plate to place tomato2.")
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        print("[Task] Placing tomato2 on the plate.")
        obs, reward, done = place(env, task, 'tomato2', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()