def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a tomato object to pick and a location to place it
        tomato_pos = positions['tomato1']  # Replace with actual object name
        drop_pos = positions['drop_zone']   # Replace with actual drop zone name

        # Step 1: Move to the tomato's position
        print("[Task] Moving to tomato position:", tomato_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato_pos)
        if done:
            print("[Task] Task ended after moving to tomato position!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, task, 'tomato1', obs.robot_position)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Move to the drop zone
        print("[Task] Moving to drop zone:", drop_pos)
        obs, reward, done = move(env, task, obs.robot_position, drop_pos)
        if done:
            print("[Task] Task ended after moving to drop zone!")
            return

        # Step 4: Place the tomato in the drop zone
        print("[Task] Placing the tomato.")
        obs, reward, done = place(env, task, 'tomato1', drop_pos)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()