def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'switch', 'object1', 'object2', etc.
        switch_pos = positions['switch']
        object1_pos = positions['object1']
        object2_pos = positions['object2']

        # Step 1: Move to the switch position
        print("[Task] Moving to switch position:", switch_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=switch_pos)
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 2: Close the gripper to prepare for pressing
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 3: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, target_pos=switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 4: Move to object1 position
        print("[Task] Moving to object1 position:", object1_pos)
        obs, reward, done = move(env, task, from_room=switch_pos, to_room=object1_pos)
        if done:
            print("[Task] Task ended after moving to object1!")
            return

        # Step 5: Pick up object1
        print("[Task] Picking up object1.")
        obs, reward, done = pick(env, task, obj='object1', room=object1_pos)
        if done:
            print("[Task] Task ended after picking up object1!")
            return

        # Step 6: Move to object2 position
        print("[Task] Moving to object2 position:", object2_pos)
        obs, reward, done = move(env, task, from_room=object1_pos, to_room=object2_pos)
        if done:
            print("[Task] Task ended after moving to object2!")
            return

        # Step 7: Place object1 at object2 position
        print("[Task] Placing object1 at object2 position.")
        obs, reward, done = place(env, task, obj='object1', room=object2_pos)
        if done:
            print("[Task] Task ended after placing object1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()