def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'tomato1' and 'tomato2'
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # Step 1: Move to the first tomato
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Close the gripper to pick up the first tomato
        print("[Task] Closing gripper to pick up tomato1.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after attempting to close gripper!")
            return

        # Step 3: Place the first tomato on the plate
        print("[Task] Placing tomato1 on the plate at:", plate_pos)
        obs, reward, done = place(env, task, obj='tomato1', loc=plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 4: Move to the second tomato
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 5: Close the gripper to pick up the second tomato
        print("[Task] Closing gripper to pick up tomato2.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after attempting to close gripper!")
            return

        # Step 6: Place the second tomato on the plate
        print("[Task] Placing tomato2 on the plate at:", plate_pos)
        obs, reward, done = place(env, task, obj='tomato2', loc=plate_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()